/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.shape.BoxPortalShape;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;
import qouteall.q_misc_util.my_util.Plane;

@Environment(value=EnvType.CLIENT)
public class PortalRendering {
    private static final Stack<Portal> portalLayers = new Stack();
    private static boolean isRenderingCache = false;
    private static boolean isRenderingOddNumberOfMirrorsCache = false;

    public static void pushPortalLayer(Portal portal) {
        portalLayers.push(portal);
        PortalRendering.updateCache();
    }

    public static void popPortalLayer() {
        portalLayers.pop();
        PortalRendering.updateCache();
    }

    private static void updateCache() {
        isRenderingCache = PortalRendering.getPortalLayer() != 0;
        int mirrorNum = 0;
        for (Portal portal : portalLayers) {
            if (!(portal instanceof Mirror)) continue;
            ++mirrorNum;
        }
        isRenderingOddNumberOfMirrorsCache = mirrorNum % 2 == 1;
    }

    public static int getPortalLayer() {
        return portalLayers.size();
    }

    public static boolean isRendering() {
        return isRenderingCache;
    }

    public static boolean isRenderingOddNumberOfMirrors() {
        return isRenderingOddNumberOfMirrorsCache;
    }

    public static int getMaxPortalLayer() {
        if (RenderStates.isLaggy) {
            return 1;
        }
        return IPGlobal.maxPortalLayer;
    }

    @NotNull
    public static Portal getRenderingPortal() {
        return portalLayers.peek();
    }

    public static void onBeginPortalWorldRendering() {
        List currRenderInfo = portalLayers.stream().map(WeakReference::new).collect(Collectors.toList());
        RenderStates.portalRenderInfos.add(currRenderInfo);
        ++RenderStates.portalsRenderedThisFrame;
        if (portalLayers.stream().anyMatch(PortalLike::hasScaling)) {
            RenderStates.renderedScalingPortal = true;
        }
        CHelper.checkGlError();
    }

    public static void onEndPortalWorldRendering() {
        RenderStates.renderedDimensions.add(portalLayers.peek().getDestDim());
    }

    public static class_243 getRenderingCameraPos() {
        class_243 pos = RenderStates.originalCamera.method_19326();
        for (Portal portal : portalLayers) {
            pos = portal.transformPoint(pos);
        }
        return pos;
    }

    public static double getExtraModelViewScaling() {
        double scale = 1.0;
        for (Portal portal : portalLayers) {
            if (PortalRenderer.shouldApplyScaleToModelView(portal)) continue;
            scale *= portal.getScale();
        }
        return scale;
    }

    public static boolean shouldEnableSodiumCaveCulling() {
        if (PortalRendering.isRendering()) {
            Portal renderingPortal = PortalRendering.getRenderingPortal();
            if (renderingPortal.getPortalShape() instanceof BoxPortalShape) {
                return false;
            }
            class_243 currentCameraPos = CHelper.getCurrentCameraPos();
            class_243 originalCameraPos = renderingPortal.inverseTransformPoint(currentCameraPos);
            double distance = renderingPortal.getDistanceToNearestPointInPortal(originalCameraPos);
            return distance < 5.0;
        }
        return false;
    }

    public static boolean shouldRenderHitResult() {
        if (PortalRendering.isRendering()) {
            class_239 hitResult = class_310.method_1551().field_1765;
            if (hitResult == null) {
                return false;
            }
            Portal renderingPortal = PortalRendering.getRenderingPortal();
            if (renderingPortal instanceof Mirror) {
                return false;
            }
            if (hitResult instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)hitResult;
                if (hitResult.method_17783() == class_239.class_240.field_1332) {
                    class_2338 blockPos = blockHitResult.method_17777();
                    Plane innerClipping = renderingPortal.getInnerClipping();
                    if (innerClipping != null) {
                        boolean roughlyInside = innerClipping.move(-0.1).isPointOnPositiveSide(class_243.method_24953((class_2382)blockPos));
                        return roughlyInside;
                    }
                }
            }
        }
        return true;
    }

    @Nullable
    public static Plane getActiveClippingPlane() {
        Portal renderingPortal = PortalRendering.getRenderingPortal();
        Plane plane = renderingPortal.getInnerClipping();
        if (plane == null && portalLayers.size() >= 2) {
            for (int i = portalLayers.size() - 2; i >= 0; --i) {
                Portal portal = (Portal)portalLayers.get(i);
                Plane outerPlane = portal.getInnerClipping();
                if (outerPlane == null) continue;
                for (int j = i + 1; j < portalLayers.size(); ++j) {
                    Portal portal1 = (Portal)portalLayers.get(j);
                    outerPlane = new Plane(portal1.transformPoint(outerPlane.pos()), portal1.transformLocalVecNonScale(outerPlane.normal()));
                }
                return outerPlane;
            }
        }
        return plane;
    }

    public static boolean isInvalidRecursionRendering(Portal toRender) {
        if (portalLayers.size() < 2) {
            return false;
        }
        Portal last = (Portal)portalLayers.get(portalLayers.size() - 1);
        Portal secondLast = (Portal)portalLayers.get(portalLayers.size() - 2);
        return toRender == secondLast && Portal.isReversePortal(toRender, last);
    }
}

